/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.ScrollManager;
import java.awt.TextComponent;
import java.awt.event.MouseEvent;

public class TextArea
extends TextComponent {
    StringBuffer starts = new StringBuffer();
    int maxWidth = 100;
    int lineH = 12;
    ScrollManager scrollManager = new ScrollManager(this, 2);

    public void paintAll(Graphics g) {
        if (!this.visible) {
            return;
        }
        this.scrollManager.paint(g);
        int i = this.scrollManager.yOffset / this.lineH;
        int cy = 10 - this.scrollManager.yOffset % this.lineH;
        int cx = 1 - this.scrollManager.xOffset;
        int lines = this.starts.length() - 1;
        while (cy < this.scrollManager.viewPortH + this.lineH && i < lines) {
            String li;
            int len;
            if ((len = (li = this.getLine(i++)).length()) > 1) {
                g.drawString(li.substring(0, len - 1), cx, cy);
            }
            cy += this.lineH;
        }
    }

    public synchronized void doLayout() {
        this.scrollManager.doLayout(this.maxWidth, (this.starts.length() - 1) * this.lineH);
    }

    public Component findComponentAt(int px, int py) {
        return this.scrollManager.findComponentAt(px, py);
    }

    String getLine(int i) {
        String tmp = this.text.toString();
        char p0 = this.starts.charAt(i);
        char p1 = this.starts.charAt(i + 1);
        return tmp.substring(p0, p1);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.maxWidth + this.scrollManager.border, (this.starts.length() - 1) * this.lineH + this.scrollManager.border);
    }

    public void setText(String text) {
        this.starts = new StringBuffer();
        int i0 = 0;
        while (true) {
            this.starts.append((char)i0);
            int i = text.indexOf(10, i0);
            if (i == -1) break;
            i0 = i + 1;
        }
        this.starts.append((char)text.length());
        super.setText(text);
    }

    public void processMouseEvent(MouseEvent me) {
        super.processMouseEvent(me);
        if (me.isConsumed()) {
            return;
        }
        if (!this.hasFocus) {
            this.requestFocus();
        }
    }
}

