/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.TooManyListenersException;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class TextComponent
extends Component {
    int caretPos;
    int caretPos0;
    char echoChar = '\u0000';
    boolean editable = true;
    TextListener textListener;
    StringBuffer text = new StringBuffer();

    public void addTextListener(TextListener tl) {
        if (this.textListener != null) {
            throw new TooManyListenersException();
        }
        this.textListener = tl;
    }

    public int getCaretPosition() {
        return this.getSelectionStart();
    }

    public String getSelectedText() {
        return this.getText().substring(this.getSelectionStart(), this.getSelectionEnd());
    }

    public int getSelectionStart() {
        return this.caretPos < this.caretPos0 ? this.caretPos : this.caretPos0;
    }

    public int getSelectionEnd() {
        return this.caretPos > this.caretPos0 ? this.caretPos : this.caretPos0;
    }

    public void drawLine(Graphics g, int x0, int y0, int p0, int p1) {
        String s;
        String line = this.text.toString().substring(p0, p1);
        int len = line.length();
        if (len > 0 && line.charAt(len - 1) < ' ') {
            line = line.substring(0, --len);
        }
        if (this.echoChar != '\u0000') {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < len) {
                sb.append(this.echoChar);
                ++i;
            }
            line = sb.toString();
        }
        boolean cursor = false;
        int lh = this.fontMetrics.getHeight();
        int ly = y0 + lh - 1;
        int ty = y0 + this.fontMetrics.getAscent();
        int cursorX = 0;
        g.setColor(Color.white);
        if (this.hasFocus) {
            int toBlack = this.getSelectionStart() - p0;
            int toWhite = this.getSelectionEnd() - p0;
            if (toBlack < 0) {
                toBlack = 0;
            } else if (toBlack > len) {
                toBlack = len;
            } else {
                cursor = true;
            }
            if (toWhite < 0) {
                toWhite = 0;
            } else if (toWhite > len) {
                toWhite = len;
            }
            s = line.substring(0, toBlack);
            int tw = this.fontMetrics.stringWidth(s);
            g.fillRect(x0, y0, tw, lh - 1);
            g.setColor(Color.gray);
            g.drawLine(x0, ly, x0 + tw, ly);
            g.setColor(Color.black);
            g.drawString(s, x0, ty);
            x0 += tw;
            s = line.substring(toBlack, toWhite);
            tw = this.fontMetrics.stringWidth(s);
            cursorX = x0;
            cursor &= tw == 0;
            g.fillRect(x0, y0, tw, lh);
            g.setColor(Color.white);
            g.drawString(s, x0, ty);
            x0 += tw;
            s = line.substring(toWhite, len);
        } else {
            s = line;
        }
        g.fillRect(x0, y0, this.w - x0, lh - 1);
        g.setColor(Color.gray);
        g.drawLine(x0, ly, this.w, ly);
        g.setColor(Color.black);
        g.drawString(s, x0, ty);
        if (cursor) {
            g.fillRect(cursorX == 0 ? 0 : cursorX - 1, y0, 2, lh);
        }
    }

    public String getText() {
        return this.text.toString();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void removeTextListener(TextListener tl) {
        this.textListener = null;
    }

    public void select(int start, int end) {
        this.caretPos0 = start;
        this.caretPos = end;
        this.repaint();
    }

    public void selectAll() {
        this.caretPos0 = 0;
        this.caretPos = this.getText().length();
        this.repaint();
    }

    public void setEditable(boolean ed) {
        if (ed != this.editable) {
            this.editable = ed;
            this.repaint();
        }
    }

    public void setCaretPosition(int cp) {
        if (cp < 0) {
            cp = 0;
        }
        if (cp > this.getText().length()) {
            cp = this.getText().length();
        }
        if (this.caretPos != cp || this.caretPos0 != cp) {
            this.caretPos = cp;
            this.caretPos0 = cp;
            this.repaint();
        }
    }

    public void setSelectionStart(int i) {
        this.caretPos0 = i;
    }

    public void setSelectionEnd(int i) {
        this.caretPos = i;
    }

    public void setText(String newText) {
        this.text = new StringBuffer(newText);
        if (this.textListener != null) {
            this.textListener.textValueChanged(new TextEvent(this, 900));
        }
        if (this.caretPos > newText.length() || this.caretPos0 > newText.length()) {
            this.setCaretPosition(newText.length());
        }
        this.repaint();
    }
}

