/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.TextComponent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class TextField
extends TextComponent {
    int minW;
    static final int minH = 12;
    int scrollOffset = 0;

    public TextField() {
        this("", 10);
    }

    public TextField(int cols) {
        this("", cols);
    }

    public TextField(String s) {
        this(s, 10);
    }

    public TextField(String text, int cols) {
        this.h = 12;
        this.w = this.minW = 7 * cols;
        this.setText(text);
    }

    public boolean echoCharIsSet() {
        return this.echoChar != '\u0000';
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.minW, 12);
    }

    public void paint(Graphics g) {
        this.drawLine(g, 0, (this.h - this.fontMetrics.getHeight()) / 2, 0, this.text.length());
    }

    public void processMouseEvent(MouseEvent me) {
        if (!this.hasFocus) {
            this.requestFocus();
        }
        int cp = 0;
        int mx = me.getX() + this.scrollOffset;
        int w = 0;
        String tmp = this.text.toString();
        while (w < mx && cp < this.text.length()) {
            w += this.fontMetrics.stringWidth(tmp.substring(cp, cp + 1));
            ++cp;
        }
        if (me.getID() == 501) {
            this.caretPos0 = cp;
        }
        if (cp != this.caretPos || me.getID() == 501) {
            this.caretPos = cp;
            this.repaint();
        }
    }

    public void processKeyEvent(KeyEvent ke) {
        super.processKeyEvent(ke);
        if (ke.isConsumed()) {
            return;
        }
        int p0 = this.getSelectionStart();
        int p1 = this.getSelectionEnd();
        this.caretPos = p0;
        this.caretPos0 = p0;
        if (ke.getID() == 256) {
            if (!this.editable) {
                return;
            }
            ++this.caretPos;
            this.caretPos0 = this.caretPos;
            int len = this.text.length();
            StringBuffer newText = new StringBuffer(len - (p1 - p0) + 1);
            int i = 0;
            while (i < p0) {
                newText.append(this.text.charAt(i));
                ++i;
            }
            newText.append(ke.getKeyChar());
            i = p1;
            while (i < len) {
                newText.append(this.text.charAt(i));
                ++i;
            }
            this.text = newText;
            this.repaint();
        } else {
            int kc = ke.getKeyCode();
            switch (kc) {
                case 37: {
                    this.setCaretPosition(p0 - 1);
                    break;
                }
                case 39: {
                    this.setCaretPosition(p1 + 1);
                    break;
                }
                case 8: {
                    if (this.caretPos > 0) {
                        --this.caretPos;
                    }
                    this.caretPos0 = this.caretPos;
                    this.text = p0 <= 1 ? TextField.deleteFromStringBuffer(this.text, 0, p1) : TextField.deleteFromStringBuffer(this.text, p0 - 1, p1);
                    this.repaint();
                    break;
                }
                default: {
                    this.text.append(ke.getKeyCode());
                    this.repaint();
                }
            }
        }
    }

    private static final StringBuffer deleteFromStringBuffer(StringBuffer text, int start, int end) {
        int len = text.length();
        StringBuffer sb = new StringBuffer(len - (end - start));
        int i = 0;
        while (i < start) {
            sb.append(text.charAt(i));
            ++i;
        }
        i = end;
        while (i < len) {
            sb.append(text.charAt(i));
            ++i;
        }
        return sb;
    }

    public void setEchoChar(char c) {
        this.echoChar = c;
        this.repaint();
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

