/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import com.sun.kjava.Spotlet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.KawtThread;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;

class Wrapper
extends Spotlet {
    static KawtThread kawtThread;
    static Wrapper wrapper;
    static Component mouseOwner;
    static int mouseOrgX;
    static int mouseOrgY;
    static Vector repaint;
    static Vector repaintRects;

    static {
        repaint = new Vector();
        repaintRects = new Vector();
    }

    Wrapper() {
        this.register(0);
        kawtThread = new KawtThread();
        kawtThread.start();
    }

    synchronized void addRepaint(Component c, Rectangle r) {
        if (!c.visible) {
            return;
        }
        int cnt = repaint.size();
        int i = 0;
        while (i < cnt) {
            Component ci = (Component)repaint.elementAt(i);
            Rectangle ri = (Rectangle)repaintRects.elementAt(i);
            if (c == ci) {
                ri.add(r);
                return;
            }
            if (c instanceof Container && ((Container)c).isAncestorOf(ci)) {
                do {
                    ri.x += ci.x;
                    ri.y += ci.y;
                } while ((ci = ci.parent) != c);
                r.add(ri);
                repaint.removeElementAt(i);
                repaintRects.removeElementAt(i);
                --i;
                --cnt;
            } else if (ci instanceof Container && ((Container)ci).isAncestorOf(c)) {
                do {
                    r.x += c.x;
                    r.y += c.y;
                } while ((c = c.parent) != ci);
                ri.add(r);
                return;
            }
            ++i;
        }
        repaint.addElement(c);
        repaintRects.addElement(r);
    }

    public synchronized void flushRepaint() {
        int cnt = repaint.size();
        int i = 0;
        while (i < cnt) {
            Component c = (Component)repaint.elementAt(i);
            Graphics g = c.getGraphics();
            if (g != null) {
                Rectangle r = (Rectangle)repaintRects.elementAt(i);
                g.clipRect(r.x, r.y, r.width, r.height);
                c.update(g);
            }
            ++i;
        }
        repaint.removeAllElements();
        repaintRects.removeAllElements();
    }

    Frame getActiveFrame() {
        int i = Frame.frames.size();
        return i > 0 ? (Frame)Frame.frames.elementAt(i - 1) : null;
    }

    public void keyDown(int keyCode) {
        Frame frame = this.getActiveFrame();
        if (frame == null) {
            return;
        }
        Window top = frame.getTopWindow();
        if (keyCode == 261) {
            if (frame.menuBar != null) {
                if (top.isMenu) {
                    do {
                        top.setVisible(false);
                        top = frame.getTopWindow();
                    } while (top.isMenu);
                } else if (frame == top) {
                    frame.menuBar.show();
                }
            }
            return;
        }
        if (top.focus == null) {
            return;
        }
        if (keyCode < 31) {
            switch (keyCode) {
                case 28: {
                    keyCode = 37;
                    break;
                }
                case 29: {
                    keyCode = 39;
                    break;
                }
                case 12: {
                    keyCode = 34;
                    break;
                }
                case 11: {
                    keyCode = 33;
                }
            }
            kawtThread.processEvent(107, top.focus, new KeyEvent(top, 257, 0L, 0, keyCode, '\u0000'));
        } else {
            kawtThread.processEvent(107, top.focus, new KeyEvent(top, 256, 0L, 0, 0, (char)keyCode));
        }
        this.flushRepaint();
    }

    public void penDown(int x, int y) {
        Frame frame = this.getActiveFrame();
        if (frame == null) {
            return;
        }
        while (true) {
            Window topWindow = frame.getTopWindow();
            Point p = topWindow.getLocationOnScreen();
            mouseOwner = topWindow.findComponentAt(x - p.x, y - p.y);
            if (mouseOwner != null) {
                p = mouseOwner.getLocationOnScreen();
                mouseOrgX = p.x;
                mouseOrgY = p.y;
                kawtThread.processEvent(109, mouseOwner, new MouseEvent(mouseOwner, 501, 0L, 0, x - mouseOrgX, y - mouseOrgY, 0, false));
                break;
            }
            if (!topWindow.isMenu) break;
            topWindow.setVisible(false);
        }
        this.flushRepaint();
    }

    public void penUp(int x, int y) {
        if (mouseOwner == null) {
            return;
        }
        kawtThread.processEvent(109, mouseOwner, new MouseEvent(mouseOwner, 502, 0L, 0, x -= mouseOrgX, y -= mouseOrgY, 0, false));
        kawtThread.processEvent(109, mouseOwner, new MouseEvent(mouseOwner, 500, 0L, 0, x, y, 0, false));
        this.flushRepaint();
    }

    public void penMove(int x, int y) {
        if (mouseOwner != null) {
            kawtThread.processEvent(109, mouseOwner, new MouseEvent(null, 506, 0L, 0, x - mouseOrgX, y - mouseOrgY, 0, false));
        }
        this.flushRepaint();
    }
}

