import java.awt.*;
import java.awt.event.*;


public class PenDemo extends Canvas implements MouseListener, 
                                               MouseMotionListener {

    int x;
    int y;
    StringBuffer coords = new StringBuffer ();

    PenDemo () {
        Frame frame = new Frame ("PenTest");
        frame.addWindowListener (new de.kawt.Closer (null));
        frame.setSize (Toolkit.getDefaultToolkit ().getScreenSize ());
        frame.add ("Center", this);
        addMouseListener (this);
        addMouseMotionListener (this);
        frame.show ();
    }
    

    public void mouseDragged (MouseEvent me) {
        Graphics g = getGraphics ();

        if (g != null) 
            g.drawLine (x, y, me.getX (), me.getY ());
        
        coords.append ((char) x);
        coords.append ((char) y);

        x = me.getX ();
        y = me.getY ();
        
        coords.append ((char) x);
        coords.append ((char) y);
    }


    public void mouseEntered (MouseEvent me) {}
    public void mouseExited (MouseEvent me) {}
    public void mouseMoved (MouseEvent me) {}


    public void mousePressed (MouseEvent me) {
        x = me.getX ();
        y = me.getY ();
    }


    public void mouseReleased (MouseEvent me) {}


    public void mouseClicked (MouseEvent me) {}

    
    public void paint (Graphics g) {
        
        int len = coords.length ();
        for (int i = 0; i < len; i+=4) 
            g.drawLine (coords.charAt (i), coords.charAt (i+1),
                        coords.charAt (i+2), coords.charAt (i+3));
    }
    
    public static void main (String [] argv) {

        new PenDemo ();
    }

}
