// KawtThread.java
//
// 2000-10-10 SH Moved some of the event handling code here.
// 2000-09-08 MK Added new Licensetext
// 2000-08-06 SH fixes for MIDP
// 2000-05-19 SH Initial version
//	
//#include ..\..\license.txt
//
// kAWT version 0.95
//
// Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
//
// Contact: kawt@kawt.de
// General Information about kAWT is available at: http://www.kawt.de
//
// Using kAWT for private and educational and in GPLed open source
// projects is free. For other purposes, a commercial license must be
// obtained. There is absolutely no warranty for non-commercial use.
//
//
// 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
//    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
//    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
//    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
//    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
//    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
//    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
//    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
//    SERVICING, REPAIR OR CORRECTION.
//   
// 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
//    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
//    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
//    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
//    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
//    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
//    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
//    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
//    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
//    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//   
//    END OF TERMS AND CONDITIONS
// 
//#endinclude


package java.awt;

import java.awt.event.*;


class KawtThread extends Thread {

    Component target;
    AWTEvent event;
    int type;
    //KawtThread save;
    Runnable run;
    Exception exception;
    Object notify;

    public synchronized void run () {

	do {
	    try {
		wait (500);
	    }
	    catch (InterruptedException e) {}

	    try {
		switch (type) {
		case 'k': 
		    deliverKeyEvent (target, (KeyEvent) event);
		    break;
		    
		case 'm': 
		    target.handleMouseEvent ((MouseEvent) event); 
		    break;
		case 'r': 
		    run.run (); // no break -> force flush!
		    
		default: 
		    Toolkit.flushRepaint ();
		}

		if (notify != null) { 
		    synchronized (notify) {
			notify.notify ();
			notify = null;
		    }
		}
	    }
	    catch (Exception e) {		
		exception = e;
		//		System.err.println ("Exception in kAWT thread: "+ e);
	    }
	    
	    if (type != 0) {
		
		if (type == 'x') type = 'y';
		else type = 0;
		notify ();
	    }
	}
	while (type != 'y');
    }


    void deliverKeyEvent (Component target, KeyEvent ke) {

	Component current = target;

	while (current != null) {
	    current.handleKeyEvent ((KeyEvent) event); 

	    if (event.consumed) return; 
	       
	    current = current.parent;
	}

	if (ke.getID () != KeyEvent.KEY_PRESSED) return;

	switch (ke.getKeyCode ()) {
	case KeyEvent.VK_PROPS:
	case KeyEvent.VK_CANCEL:
	    {
		Window top = Toolkit.getTopWindow ();
		if (top == null) break;
		if (top.isMenu) {
		    do {
			top.setVisible (false);
			top = Toolkit.getTopWindow ();
		    }
		    while (top != null && top.isMenu);
		    return;
		}
           
                if (top instanceof Frame) {
                    Frame frame = (Frame) top; 
                    if (frame.menuBar != null) {
                        frame.menuBar.show ();
                        return;
                    }
                }
	    }
	case KeyEvent.VK_ENTER:
	case KeyEvent.VK_SPACE:
	case KeyEvent.VK_ACCEPT:
	    if (target != null) target.action (ke);
	    break;

	case KeyEvent.VK_DOWN:
	case KeyEvent.VK_TAB:
	case KeyEvent.VK_RIGHT:
	    if (target != null) 
		target.getNext (true, true).requestFocus ();
	    
	    break;
	case KeyEvent.VK_UP:
	case KeyEvent.VK_LEFT:
	    if (target != null) 
		target.getPrev (true, false).requestFocus ();
	    break;    
	}
    }


    synchronized void queueEvent (int type, Component target, 
				  AWTEvent event) {
	
	this.type = type;
	this.target = target;
	this.event = event;
	
	notify ();

	do {
	    try {
		wait ();
	    }
	    catch (InterruptedException e) {
	    }
	}
	while (this.type != 0);
    }
}



