import java.awt.*;
import java.awt.event.*;
import org.xml.sax.*;


/** generates a (K)AWT window containing a list of sax events */


public class SampleDocumentHandler extends HandlerBase {

    class Closer extends WindowAdapter {
	public void windowClosing (WindowEvent ev) {
	    System.exit (0);
	}
    }

    
    List list = new List ();
    Frame frame;
    String indent = " ";

    SampleDocumentHandler (String title) {
	frame = new Frame (title);
	frame.add ("Center", list);
	frame.addWindowListener (new Closer ());
	list.add ("SAX events:");
	frame.pack ();
	frame.show ();
    }

    
    public void startDocument () {
	list.add ("startDocument");
    }

    public void endDocument () {
	list.add ("endDocument");
    }

    public void startElement (String name, AttributeList attr) {
	list.add (indent + "startElement: '" + name + "' "+attr2str (attr));
	indent = indent + " ";
    }

    public void endElement (String name) {
	indent = indent.substring (1);
	list.add (indent + "endElement " + name);
    }

    public void characters (char [] buf, int st, int len) {
	list.add (indent + "content: '"+new String (buf, st, len)+"'");
    }

    public static String attr2str (AttributeList attr) {
	StringBuffer buf = new StringBuffer ();
	for (int i = 0; i < attr.getLength(); i++) 
	   buf.append (attr.getName(i) + "='"+attr.getValue (i) + "' ");

	return buf.toString ();
    }
}
