import org.xml.sax.*;
import de.trantor.wap.WbxmlParser;
import java.io.*;
import java.awt.*;


class WbxmlParserSample extends HandlerBase {

    
    // 2nd example from WBXML doc.

    static String [] tagTable = {"CARD", "INPUT", "XYZ", "DO"};
    static String [] attrStartTable 
	= {"STYLE=LIST", "TYPE", "TYPE=TEXT", "URL=http://","NAME","KEY"};

    static String [] attrValueTable = {".org", "ACCEPT"};

    static byte[] test = {
	(byte) 0x0001, (byte) 0x0001, (byte) 0x006a, (byte) 0x0012, (byte) 'a',    
	(byte) 'b',    (byte) 'c',    (byte) 0x0000, (byte) ' ',    (byte) 'E',    
        (byte) 'n',    (byte) 't',    (byte) 'e',    (byte) 'r',    (byte) ' ',    
        (byte) 'n',    (byte) 'a',    (byte) 'm',    (byte) 'e',    (byte) ':',    
        (byte) ' ',    (byte) 0x0000, (byte) 0x0047, (byte) 0x00c5, (byte) 0x0009, 
        (byte) 0x0083, (byte) 0x0000, (byte) 0x0005, (byte) 0x0001, (byte) 0x0088, 
        (byte) 0x0006, (byte) 0x0086, (byte) 0x0008, (byte) 0x0003, (byte) 'x',    
        (byte) 'y',    (byte) 'z',    (byte) 0x0000, (byte) 0x0085, (byte) 0x0003 ,
        (byte) '/',    (byte) 's',    (byte) 0x0000, (byte) 0x0001, (byte) 0x0083, 
        (byte) 0x0004, (byte) 0x0086, (byte) 0x0007, (byte) 0x000a, (byte) 0x0003, 
        (byte) 'N',     (byte) 0x0000,(byte) 0x0001, (byte) 0x0001,(byte) 0x0001};

    // 1st example from WBXML doc.

    /*
    static byte [] test = {
	(byte) 0x001, (byte) 0x001, (byte) 0x003, (byte) 0x000, (byte)0x047, 
        (byte) 0x046, (byte) 0x003, (byte)   ' ', (byte)  'X',  (byte)  ' ',  
        (byte) '&',   (byte)   ' ', (byte)   'Y', (byte) 0x000, (byte)0x005, 
        (byte) 0x003, (byte)   ' ', (byte)   'X', (byte) 0x000, (byte)0x002, 
        (byte) 0x081, (byte) 0x020, (byte) 0x003, (byte) '=',   (byte)0x000,
        (byte) 0x002, (byte) 0x081, (byte) 0x020, (byte) 0x003, (byte) '1',  
        (byte)   ' ', (byte) 0x000, (byte) 0x001, (byte) 0x001};
    */


    public static void main (String [] args) throws IOException, SAXException {

	WbxmlParser parser = new WbxmlParser ();
	DocumentHandler handler = new SampleDocumentHandler ("WbxmlParserSample");

	parser.setTagTable (0, tagTable);
	parser.setAttrStartTable (0, attrStartTable);
	parser.setAttrValueTable (0, attrValueTable);
	parser.setDocumentHandler (handler);

	parser.parse (new ByteArrayInputStream (test));
    }
}

